<?php 
    include 'db_connect.php'; 
    include 'header.php'; 
?>

<section style="background: var(--primary-color); color: white; padding: 40px 0; text-align: center; margin-top: 80px;">
    <h1 style="font-family: 'Playfair Display', serif; margin-bottom: 10px;">Live Case Status</h1>
    <p style="opacity: 0.8;">Real-time updates from the Court Registrars</p>
    <div style="font-size: 1.5rem; font-weight: bold; margin-top: 10px;" id="clock">00:00:00</div>
</section>

<section class="content-section" style="padding: 40px 5%; background-color: #eee; min-height: 70vh;">
    
    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(350px, 1fr)); gap: 30px;">
        
        <div style="background: white; border-radius: 10px; overflow: hidden; box-shadow: 0 10px 20px rgba(0,0,0,0.1);">
            <div style="background: #333; color: white; padding: 15px; text-align: center;">
                <h2 style="margin: 0; font-size: 1.8rem;">Court No. 01</h2>
                <p style="margin: 0; font-size: 0.9rem; color: var(--gold-accent);">Hon. Justice A.B.C. Perera</p>
            </div>
            <div style="padding: 30px; text-align: center;">
                <h4 style="color: #888; text-transform: uppercase; letter-spacing: 1px;">Currently Taking Up</h4>
                <div style="font-size: 2.5rem; color: var(--primary-color); font-weight: 700; margin: 10px 0;">WP/HCCA/COL/112/25</div>
                <span style="background: #d4edda; color: #155724; padding: 5px 15px; border-radius: 20px; font-weight: bold; font-size: 0.9rem;">ARGUMENT</span>
                
                <hr style="margin: 20px 0; border: 0; border-top: 1px solid #eee;">
                
                <p style="color: #666; margin-bottom: 5px;">Next Case:</p>
                <p style="font-weight: bold; font-size: 1.2rem;">WP/HCCA/COL/115/25</p>
            </div>
        </div>

        <div style="background: white; border-radius: 10px; overflow: hidden; box-shadow: 0 10px 20px rgba(0,0,0,0.1);">
            <div style="background: #333; color: white; padding: 15px; text-align: center;">
                <h2 style="margin: 0; font-size: 1.8rem;">Court No. 02</h2>
                <p style="margin: 0; font-size: 0.9rem; color: var(--gold-accent);">Hon. Justice S.D. Silva</p>
            </div>
            <div style="padding: 30px; text-align: center;">
                <h4 style="color: #888; text-transform: uppercase; letter-spacing: 1px;">Currently Taking Up</h4>
                <div style="font-size: 2.5rem; color: var(--primary-color); font-weight: 700; margin: 10px 0;">WP/HCCA/GPH/05/26</div>
                <span style="background: #fff3cd; color: #856404; padding: 5px 15px; border-radius: 20px; font-weight: bold; font-size: 0.9rem;">MENTION</span>
                
                <hr style="margin: 20px 0; border: 0; border-top: 1px solid #eee;">
                
                <p style="color: #666; margin-bottom: 5px;">Next Case:</p>
                <p style="font-weight: bold; font-size: 1.2rem;">WP/HCCA/GPH/08/26</p>
            </div>
        </div>

    </div>

    <div style="text-align: center; margin-top: 40px; color: #666; font-style: italic;">
        <p><i class="fas fa-sync fa-spin"></i> Auto-refreshing every 60 seconds.</p>
    </div>

</section>

<script>
    // Simple Clock Script
    function updateClock() {
        const now = new Date();
        const timeString = now.toLocaleTimeString();
        document.getElementById('clock').textContent = timeString;
    }
    setInterval(updateClock, 1000);
    updateClock();
</script>

<?php include 'footer.php'; ?>